///////////////////////////////////////////////////////////////////////////////////////
//
// MonoScan
//
// 27/04/07		Hounddog	Initial implementation
//

using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Xml;

namespace MonoScan.MonoMotronic121
{
	public class BasicSettingsForm : System.Windows.Forms.Form
	{
		private System.ComponentModel.IContainer components;

		public BasicSettingsForm(Scanner scanner, XmlNode xmlNode)
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			this.scanner = scanner;
			this.xmlNode = xmlNode;

			started = false;
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.idleTimer = new System.Windows.Forms.Timer(this.components);
			this.toolTip = new System.Windows.Forms.ToolTip(this.components);
			// 
			// idleTimer
			// 
			this.idleTimer.Interval = 400;
			this.idleTimer.Tick += new System.EventHandler(this.idleTimer_Tick);
			// 
			// toolTip
			// 
			this.toolTip.ShowAlways = true;
			// 
			// BasicSettingsForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(584, 317);
			this.Name = "BasicSettingsForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
			this.Text = "Basic Settings";
			this.WindowState = System.Windows.Forms.FormWindowState.Maximized;

		}
		#endregion

		System.Windows.Forms.Timer idleTimer;
		System.Windows.Forms.ToolTip toolTip;

		Scanner scanner;
		XmlNode xmlNode;

		bool started;

		public void Start()
		{
			bool idling = MessageBox.Show(scanner.MainForm, "Is engine idling ?", "MonoScan", 
				MessageBoxButtons.YesNo, MessageBoxIcon.Question) == DialogResult.Yes;

			statusMessageId = scanner.MainForm.PushStatusMessage("Basic Settings");

			try
			{
				MonoComm.Status status = MonoComm.GetBasicSettingsVar(out zones);

				if (status != MonoComm.Status.Ok)
					throw new MonoComm.Exception(status);

				zoneIndicators = new ZoneIndicator[zones.Length];

				XmlNode zonesXmlNode = Configuration.FindXmlNode(xmlNode, "Zones[@Idling=\"{0}\"]", idling);				

				if (zonesXmlNode != null)
				{
					XmlNodeList zoneXmlNodeList = zonesXmlNode.ChildNodes;

					for (int index = 0; index < zoneXmlNodeList.Count; ++ index)
					{
						XmlNode zoneXmlNode = zoneXmlNodeList[index];

						int zoneCode;
						ZoneIndicator zoneIndicator;

						if (zoneXmlNode.Name == "Zone")
						{
							zoneCode = int.Parse(Configuration.GetXmlNodeAttribute(zoneXmlNode, "Code"));
							zoneIndicator = CreateZoneArrowIndicator(zoneXmlNode);
						}
						else if (zoneXmlNode.Name == "ZoneStatus")
						{
							zoneCode = int.Parse(Configuration.GetXmlNodeAttribute(zoneXmlNode, "Code"));
							zoneIndicator = CreateZoneStatusIndicator(zoneXmlNode);
						}
						else
							continue;

						if (zoneCode > 0 && zoneCode <= zoneIndicators.Length)
							zoneIndicators[zoneCode - 1] = zoneIndicator;
					}
				}

				for (int index = 0; index < zones.Length; ++ index)
				{
					if (zoneIndicators[index] == null)
					{
						ZoneArrowIndicator zoneArrowIndicator = new ZoneArrowIndicator();
						zoneArrowIndicator.Caption = "Zone " + (index + 1).ToString();
						zoneArrowIndicator.Range = new Range(0, 255);

						zoneIndicators[index] = zoneArrowIndicator;
					}

					if (index == 5 || index == 6)
					{
						zoneIndicators[index].Value = (sbyte) zones[index];
					}
					else
						zoneIndicators[index].Value = zones[index];
				}

				Controls.AddRange(zoneIndicators);
				
				idleTimer.Enabled = true;
				scanner.MainForm.IdleEnabled = false;

				started = true;
			}
			catch
			{
				scanner.MainForm.PopStatusMessage(statusMessageId);
                
				throw;
			}
		}

		ZoneArrowIndicator CreateZoneArrowIndicator(XmlNode zoneXmlNode)
		{
			ZoneArrowIndicator zoneArrowIndicator = new ZoneArrowIndicator();

			string caption = Configuration.FindXmlNodeAttribute(zoneXmlNode, "Caption");

			if (caption != null)
			{
				zoneArrowIndicator.Caption = caption;
			}
			else
			{
				string code = Configuration.GetXmlNodeAttribute(zoneXmlNode, "Code");
				zoneArrowIndicator.Caption = "Zone " + code;
			}

			XmlNode rangeXmlNode = Configuration.FindXmlNode(zoneXmlNode, "Range");

			if (rangeXmlNode != null)
			{
				Range range = new Range(
					int.Parse(Configuration.GetXmlNodeAttribute(rangeXmlNode, "Min")),
					int.Parse(Configuration.GetXmlNodeAttribute(rangeXmlNode, "Max")));

				zoneArrowIndicator.Range = range;
			}

			XmlNode normalRangeXmlNode = Configuration.FindXmlNode(zoneXmlNode, "NormalRange");

			if (normalRangeXmlNode != null)
			{
				Range normalRange = new Range(
					int.Parse(Configuration.GetXmlNodeAttribute(normalRangeXmlNode, "Min")),
					int.Parse(Configuration.GetXmlNodeAttribute(normalRangeXmlNode, "Max")));

				zoneArrowIndicator.NormalRange = normalRange;
			}

			XmlNodeList pointsXmlNodeList = Configuration.FindXmlNodes(zoneXmlNode, "Points/Point");

			if (pointsXmlNodeList != null && pointsXmlNodeList.Count != 0)
			{
				Point[] points = new Point[pointsXmlNodeList.Count];

				for (int i = 0; i < pointsXmlNodeList.Count; ++ i)
				{
					XmlNode pointXmlNode = pointsXmlNodeList[i];

					Point point = new Point(
						int.Parse(Configuration.GetXmlNodeAttribute(pointXmlNode, "X")),
						int.Parse(Configuration.GetXmlNodeAttribute(pointXmlNode, "Y")));

					points[i] = point;
				}

				zoneArrowIndicator.Points = points;
			}

			string weight = Configuration.FindXmlNodeAttribute(zoneXmlNode, "Weight");

			if (weight != null)
				zoneArrowIndicator.Weight = int.Parse(weight);

			string unit = Configuration.FindXmlNodeAttribute(zoneXmlNode, "Unit");

			if (unit != null)
				zoneArrowIndicator.Unit = unit;

			string description = Configuration.FindXmlNodeAttribute(zoneXmlNode, "Description");

			if (description != null)
				toolTip.SetToolTip(zoneArrowIndicator, description);

			return zoneArrowIndicator;
		}

		ZoneStatusIndicator CreateZoneStatusIndicator(XmlNode zoneXmlNode)
		{
			ZoneStatusIndicator zoneStatusIndicator = new ZoneStatusIndicator();

			string caption = Configuration.FindXmlNodeAttribute(zoneXmlNode, "Caption");

			if (caption != null)
			{
				zoneStatusIndicator.Caption = caption;
			}
			else
			{
				string code = Configuration.GetXmlNodeAttribute(zoneXmlNode, "Code");
				zoneStatusIndicator.Caption = "Zone " + code;
			}

			XmlNodeList bitsXmlNodeList = Configuration.FindXmlNodes(zoneXmlNode, "Bits/Bit");

			if (bitsXmlNodeList != null && bitsXmlNodeList.Count != 0)
			{
				ZoneStatusBit[] zoneStatusBits = new ZoneStatusBit[bitsXmlNodeList.Count];

				for (int index = 0; index < bitsXmlNodeList.Count; ++ index)
				{
					XmlNode bitXmlNode = bitsXmlNodeList[index];

					ZoneStatusBit zoneStatusBit = new ZoneStatusBit(
						int.Parse(Configuration.GetXmlNodeAttribute(bitXmlNode, "Code")),
						Configuration.GetXmlNodeAttribute(bitXmlNode, "Description"));

					zoneStatusBits[index] = zoneStatusBit;
				}

				zoneStatusIndicator.Bits = zoneStatusBits;
			}

			string length = Configuration.FindXmlNodeAttribute(zoneXmlNode, "Length");

			if (length != null)
				zoneStatusIndicator.Length = int.Parse(length);

			string description = Configuration.FindXmlNodeAttribute(zoneXmlNode, "Description");

			if (description != null)
				toolTip.SetToolTip(zoneStatusIndicator, description);

			return zoneStatusIndicator;
		}

		void idleTimer_Tick(object sender, System.EventArgs e)
		{
			try
			{
				MonoComm.Status status = MonoComm.GetBasicSettings(zones);

				if (status != MonoComm.Status.Ok)
				{
					if (status == MonoComm.Status.ErrorEcu)
					{
						// TODO: comment

						for (int index = 0; index < zoneIndicators.Length; ++ index)
							zoneIndicators[index].Value = ZoneArrowIndicator.NotAvailableValue;

						return;
					}

					throw new MonoComm.Exception(status);
				}

				for (int index = 0; index < zones.Length; ++ index)
				{
					if (index == 5 || index == 6)
					{
						zoneIndicators[index].Value = (sbyte) zones[index];
					}
					else
						zoneIndicators[index].Value = zones[index];
				}
			}
			catch (MonoComm.Exception exception)
			{
				Close();

				scanner.MainForm.HandleMonoCommException("Couldn't keep basic settings", exception);
			}
			catch (Exception exception)
			{
				Close();

				scanner.MainForm.HandleException("Couldn't keep basic settings", exception);
			}
		}		

		int statusMessageId;

		byte[] zones;
		ZoneIndicator[] zoneIndicators;

		protected override void OnLayout(LayoutEventArgs levent)
		{
			base.OnLayout(levent);

			if (zoneIndicators != null)
			{
				Rectangle rectangle = ClientRectangle;

				int top = 0;
				int left = 0;
				int height = rectangle.Height / 2;
				int width = rectangle.Width / (zoneIndicators.Length / 2);

				int rowCount = (zoneIndicators.Length + 1) / 2;

				for (int index = 0; index < zoneIndicators.Length; ++ index)
				{
					ZoneIndicator zoneIndicator = zoneIndicators[index];

					zoneIndicator.SetBounds(left, top, width, height);

					if (index == rowCount - 1)
					{
						left = 0;
						top = height;
					}
					else
						left += width;
				}
			}
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose(bool disposing)
		{
			if (disposing)
			{
				if (started)
				{
					scanner.MainForm.IdleEnabled = true;
					idleTimer.Enabled = false;

					scanner.MainForm.PopStatusMessage(statusMessageId);

					started = false;
				}

				idleTimer.Dispose();

				if (components != null)
					components.Dispose();
			}

			base.Dispose(disposing);
		}
	}
}